<?php 
    /*
     *
     * copyright (c) 2013-2022 Heliac Technologies
     * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
     *
     * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
     */

    class SezioneSdoppiata {
        private $db;
        private $id;
        private $nome;
        private $spazioOccupato;
        private $proporzioni;
        private $altezza;
        private $usaParallax;
        private $doveSiTrovaImmagine;
        private $doveSiTrovaImmagineSuMobile;
        private $stileImmagine;
        private $animazioneImmagine;
        private $testo;
        private $classeDivImmagine;
        private $classeDivTesto;
        private $animazioneTesto;
        private $coloreDivTesto;
        private $immagine;
        private $tagAltImmagine;
        
        public function __construct($db, $id, $nome="", $proporzioni="", $spazioOccupato="", $altezza="", $usaParallax="", $doveSiTrovaImmagine="", $doveSiTrovaImmagineSuMobile="", $stileImmagine="", $animazioneImmagine="", $testo="", $classeDivImmagine="", $classeDivTesto="", $animazioneTesto="", $coloreDivTesto="", $immagine="") {
            $this->db = $db;
            $this->id = $id;
            $this->nome                = $nome;
            $this->spazioOccupato      = $spazioOccupato;
            $this->proporzioni         = $proporzioni;
            $this->altezza             = $altezza;
            $this->usaParallax         = $usaParallax;
            $this->doveSiTrovaImmagine = $doveSiTrovaImmagine;
            $this->doveSiTrovaImmagineSuMobile = $doveSiTrovaImmagineSuMobile;
            $this->stileImmagine       = $stileImmagine;
            $this->animazioneImmagine  = $animazioneImmagine;
            $this->testo               = $testo;
            $this->classeDivImmagine   = $classeDivImmagine;
            $this->classeDivTesto      = $classeDivTesto;
            $this->animazioneTesto     = $animazioneTesto;
            $this->coloreDivTesto      = $coloreDivTesto;
            $this->immagine            = $immagine;
        }

        function crea() {
            $query ="INSERT INTO `geec_sezioniSdoppiate` (`id`, `nome`, `spazioOccupato`, `proporzioni`, `altezza`, `usaParallax`, `doveSiTrovaImmagine`, `doveSiTrovaImmagineSuMobile`, `stileImmagine`, `animazioneImmagine`, `testo`, `classeDivImmagine`, `classeDivTesto`, `animazioneTesto`, `coloreDivTesto`, `immagine`,`tagAltImmagine`) 
                                                        VALUES (NULL, '$this->nome', '$this->spazioOccupato', '$this->proporzioni', '$this->altezza', '$this->usaParallax', '$this->doveSiTrovaImmagine', '$this->doveSiTrovaImmagineSuMobile', '$this->stileImmagine', '$this->animazioneImmagine', '$this->testo', '$this->classeDivImmagine', '$this->classeDivTesto', '$this->animazioneTesto', '$this->coloreDivTesto', '$this->immagine','$this->tagAltImmagine');";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query    = "UPDATE geec_sezioniSdoppiate SET nome='$this->nome', spazioOccupato='$this->spazioOccupato', proporzioni='$this->proporzioni', altezza='$this->altezza', usaParallax='$this->usaParallax', doveSiTrovaImmagine='$this->doveSiTrovaImmagine', doveSiTrovaImmagineSuMobile='$this->doveSiTrovaImmagineSuMobile', stileImmagine='$this->stileImmagine', animazioneImmagine='$this->animazioneImmagine', testo='$this->testo', classeDivImmagine='$this->classeDivImmagine', classeDivTesto='$this->classeDivTesto', animazioneTesto='$this->animazioneTesto', coloreDivTesto='$this->coloreDivTesto', tagAltImmagine='$this->tagAltImmagine' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function cambiaImmagine($immagine) {
            $query    = "UPDATE geec_sezioniSdoppiate SET immagine='$immagine' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_sezioniSdoppiate",$this->id);
            
            // elimina le occorrenze nelle pagine, l'id di questo componente è 27
            $queryEliminaOccorrenzeComposizionePagine = "DELETE FROM geecB_composizionePagine WHERE idElemento = $this->id AND idComponente = 27";
            $this->db->eseguiQueryScrittura($queryEliminaOccorrenzeComposizionePagine);
        }
        
        function duplica($prefisso = "Copia di ") {
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geec_sezioniSdoppiate WHERE id={$this->id}");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geec_sezioniSdoppiate SELECT * FROM tabella_temporanea;");
            $idContenutoDuplicato = $this->db->idUltimoElemento();
            
            $this->db->eseguiQueryScrittura("UPDATE geec_sezioniSdoppiate SET nome = CONCAT('$prefisso', ' ', nome) WHERE id=$idContenutoDuplicato");
            return $idContenutoDuplicato;
        }
        
        function caricaDatiDalDatabase() {
            $datiOccorrenza = $this->db->leggiSingolaRiga("geec_sezioniSdoppiate",$this->id);
            $this->nome                = $datiOccorrenza["nome"];
            $this->spazioOccupato      = $datiOccorrenza["spazioOccupato"];
            $this->proporzioni         = $datiOccorrenza["proporzioni"];
            $this->altezza             = $datiOccorrenza["altezza"];
            $this->usaParallax         = $datiOccorrenza["usaParallax"];
            $this->doveSiTrovaImmagine = $datiOccorrenza["doveSiTrovaImmagine"];
            $this->doveSiTrovaImmagineSuMobile = $datiOccorrenza["doveSiTrovaImmagineSuMobile"];
            $this->stileImmagine       = $datiOccorrenza["stileImmagine"];
            $this->animazioneImmagine  = $datiOccorrenza["animazioneImmagine"];
            $this->testo               = $datiOccorrenza["testo"];
            $this->classeDivImmagine   = $datiOccorrenza["classeDivImmagine"];
            $this->classeDivTesto      = $datiOccorrenza["classeDivTesto"];
            $this->animazioneTesto     = $datiOccorrenza["animazioneTesto"];
            $this->coloreDivTesto      = $datiOccorrenza["coloreDivTesto"];
            $this->immagine            = $datiOccorrenza["immagine"];
            $this->tagAltImmagine      = $datiOccorrenza["tagAltImmagine"];
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getSpazioOccupato() {
            return $this->spazioOccupato;
        }

        public function getProporzioni() {
            return $this->proporzioni;
        }

        public function getAltezza() {
            return $this->altezza;
        }

        public function getUsaParallax() {
            return $this->usaParallax;
        }

        public function getDoveSiTrovaImmagine() {
            return $this->doveSiTrovaImmagine;
        }

        public function getDoveSiTrovaImmagineSuMobile() {
            return $this->doveSiTrovaImmagineSuMobile;
        }

        public function getStileImmagine() {
            return $this->stileImmagine;
        }

        public function getAnimazioneImmagine() {
            return $this->animazioneImmagine;
        }

        public function getTesto() {
            return $this->testo;
        }

        public function getClasseDivImmagine() {
            return $this->classeDivImmagine;
        }

        public function getClasseDivTesto() {
            return $this->classeDivTesto;
        }

        public function getAnimazioneTesto() {
            return $this->animazioneTesto;
        }

        public function getColoreDivTesto() {
            return $this->coloreDivTesto;
        }

        public function getImmagine() {
            return $this->immagine;
        }
        
        public function getTagAltImmagine() {
            return $this->tagAltImmagine;
        }
        
        public function setDb($db): void {
            $this->db = $db;
        }

        public function setId($id): void {
            $this->id = $id;
        }

        public function setNome($nome): void {
            $this->nome = $nome;
        }

        public function setSpazioOccupato($spazioOccupato): void {
            $this->spazioOccupato = $spazioOccupato;
        }

        public function setProporzioni($proporzioni): void {
            $this->proporzioni = $proporzioni;
        }
        
        public function setAltezza($altezza): void {
            $this->altezza = $altezza;
        }

        public function setUsaParallax($usaParallax): void {
            $this->usaParallax = $usaParallax;
        }

        public function setDoveSiTrovaImmagine($doveSiTrovaImmagine): void {
            $this->doveSiTrovaImmagine = $doveSiTrovaImmagine;
        }
        
        public function setDoveSiTrovaImmagineSuMobile($doveSiTrovaImmagineSuMobile): void {
            $this->doveSiTrovaImmagineSuMobile = $doveSiTrovaImmagineSuMobile;
        }
        
        public function setStileImmagine($stileImmagine): void {
            $this->stileImmagine = $stileImmagine;
        }

        public function setAnimazioneImmagine($animazioneImmagine): void {
            $this->animazioneImmagine = $animazioneImmagine;
        }

        public function setTesto($testo): void {
            $this->testo = $testo;
        }

        public function setClasseDivImmagine($classeDivImmagine): void {
            $this->classeDivImmagine = $classeDivImmagine;
        }

        public function setClasseDivTesto($classeDivTesto): void {
            $this->classeDivTesto = $classeDivTesto;
        }

        public function setAnimazioneTesto($animazioneTesto): void {
            $this->animazioneTesto = $animazioneTesto;
        }

        public function setColoreDivTesto($coloreDivTesto): void {
            $this->coloreDivTesto = $coloreDivTesto;
        }

        public function setImmagine($immagine): void {
            $this->immagine = $immagine;
        }

        public function setTagAltImmagine($tagAltImmagine): void {
            $this->tagAltImmagine = $tagAltImmagine;
        }

    }